/*
 * update July, the 6th of 2002
 * - bugfix : set speed data counter is p->fx[15], not p->[31]
 * update April, the 11th of 2003
 * - added StarTrekker case ...
 * update Feb, the 12th of 2006
 * - bugfix : force 0x00 at end of title and end of samplename ...
 * update Jun, the 9th of 2006
 * - bugfix : unknown non-empty notes counter fixed
*/


#include "modinfo2.h"

void readPatternStuff ( struct modGeneral *mgen, struct patStats *p, unsigned char *data, long *poss  )
{
  long i,j,where;
  long fx,smp,note;
  unsigned char fxarg;
  BZERO ( p, sizeof ( struct patStats ));
  for ( i=0; i<mgen->modNbrPatternStored; i++ )
  {
    for ( j=0; j<(mgen->modPatDefaultSiz / 4); j++ )
    {
      where = mgen->modHeadSize+j*4+i*mgen->modPatDefaultSiz;
      fx = data[where+2] & 0x0f;
      fxarg = data[where+3];
      smp = (data[where] & 0xf0) | ((data[where+2]>>4) & 0x0f);
      note = ((data[where] & 0x0f) * 256) + data[where+1];

      fillFXStuff ( fx, fxarg, p );
      if ( smp != 0 && smp < 0x20)
	p->smp[smp-1] += 1;
      fillNoteStuff ( note, p, poss );
    }
  }
}

void fprintfSpecialNotes ( struct patStats *p, FILE *out )
{
  fprintf ( out,
	    "\n\nNOTES USED IN PATTERNS :\n"
	    "no note : %ld\n"
	    "C-3 : %4ld   | C-4 : %4ld   | C-5 : %4ld\n"
	    "C#3 : %4ld   | C#4 : %4ld   | C#5 : %4ld\n"
	    "D-3 : %4ld   | D-4 : %4ld   | D-5 : %4ld\n"
	    "D#3 : %4ld   | D#4 : %4ld   | D#5 : %4ld\n"
	    "E-3 : %4ld   | E-4 : %4ld   | E-5 : %4ld\n"
	    "F-3 : %4ld   | F-4 : %4ld   | F-5 : %4ld\n"
	    "F#3 : %4ld   | F#4 : %4ld   | F#5 : %4ld\n"
	    "G-3 : %4ld   | G-4 : %4ld   | G-5 : %4ld\n"
	    "G#3 : %4ld   | G#4 : %4ld   | G#5 : %4ld\n"
	    "A-3 : %4ld   | A-4 : %4ld   | A-5 : %4ld\n"
	    "A#3 : %4ld   | A#4 : %4ld   | A#5 : %4ld\n"
	    "B-3 : %4ld   | B-4 : %4ld   | B-5 : %4ld\n"
	    "unknown not empty notes : %ld\n"
	    ,p->note[0]
	    ,p->note[1], p->note[13], p->note[25]
	    ,p->note[2], p->note[14], p->note[26]
	    ,p->note[3], p->note[15], p->note[27]
	    ,p->note[4], p->note[16], p->note[28]
	    ,p->note[5], p->note[17], p->note[29]
	    ,p->note[6], p->note[18], p->note[30]
	    ,p->note[7], p->note[19], p->note[31]
	    ,p->note[8], p->note[20], p->note[32]
	    ,p->note[9], p->note[21], p->note[33]
	    ,p->note[10],p->note[22], p->note[34]
	    ,p->note[11],p->note[23], p->note[35]
	    ,p->note[12],p->note[24], p->note[36]
	    ,p->note[37] );
}

void fillNoteStuff ( long note, struct patStats *p, long *poss )
{
  long i;
  for ( i=0; i<37; i++ )
  {
    if ( note == poss[i] )
    {
      p->note[i] += 1;
      return;
    }
  }
  p->note[37] += 1;
}

void fprintfSpecialFX ( struct patStats *p, FILE *out )
{
  fprintf ( out, "\n\nPROTRACKER EFFECTS USED :\n" );
  fprintf ( out,
	    "Arpeggio        [0] : %4ld   |  Set filter          [E0] : %4ld\n"
	    "Slide up        [1] : %4ld   |  Fine Slide up       [E1] : %4ld\n"
	    "Slide down      [2] : %4ld   |  Fine Slide down     [E2] : %4ld\n"
	    "Tone portamento [3] : %4ld   |  Set glissendo       [E3] : %4ld\n"
	    "Vibrato         [4] : %4ld   |  Set vibrato         [E4] : %4ld\n"
	    "3+A             [5] : %4ld   |  Set finetune        [E5] : %4ld\n"
	    "4+A             [6] : %4ld   |  Set loop            [E6] : %4ld\n"
	    "Tremolo         [7] : %4ld   |  Set tremolo         [E7] : %4ld\n"
	    "                [8] : %4ld   |                      [E8] : %4ld\n"
	    "Sample offset   [9] : %4ld   |  Rettriger           [E9] : %4ld\n"
	    "Volume slide    [A] : %4ld   |  Fine vol slide up   [EA] : %4ld\n"
	    "Position jump   [B] : %4ld   |  Fine vol slide down [EB] : %4ld\n"
	    "Set volume      [C] : %4ld   |  Note cut            [EC] : %4ld\n"
	    "Pattern break   [D] : %4ld   |  Note delay          [ED] : %4ld\n"
	    "Set speed       [F] : %4ld   |  Pattern delay       [EE] : %4ld\n"
	    "Set BPM         [F] : %4ld   |  Invert loop         [EF] : %4ld\n"
	    , p->fx[0], p->fx[16]
	    , p->fx[1], p->fx[17]
	    , p->fx[2], p->fx[18]
	    , p->fx[3], p->fx[19]
	    , p->fx[4], p->fx[20]
	    , p->fx[5], p->fx[21]
	    , p->fx[6], p->fx[22]
	    , p->fx[7], p->fx[23]
	    , p->fx[8], p->fx[24]
	    , p->fx[9], p->fx[25]
	    , p->fx[10], p->fx[26]
	    , p->fx[11], p->fx[27]
	    , p->fx[12], p->fx[28]
	    , p->fx[13], p->fx[29]
	    , p->fx[15], p->fx[30]
	    , p->fx[14], p->fx[31] );
}

void fillFXStuff ( long fx, unsigned char fxarg, struct patStats *p )
{
  switch (fx)
  {
  case 0:
    if (fxarg != 0 )
      p->fx[0] += 1;
    break;
  case 1:
  case 2:
  case 3:
  case 4:
  case 5:
  case 6:
  case 7:
  case 8:
  case 9:
  case 10: /* 0x0a */
  case 11: /* 0x0b */
  case 12: /* 0x0c */
  case 13: /* 0x0d */
    p->fx[fx] += 1;
    break;
  case 15: /* 0x0f */
    if (fxarg > 0x1F)
      p->fx[14] += 1;
    else
      p->fx[15] += 1;
    break;
  case 14: /* 0x0e -> extended FXs*/
    p->fx[((fxarg>>4)&0x0f) + 16] += 1;
    break;
  }
}

void fprintfSpecialPatList ( struct modHead *m, FILE *out )
{
  long i;
  fprintf ( out, "PATTERN LIST :" );
  for ( i=0; i<m->modPatternListSize; i++ )
  {
    if ( (i%10) == 0)
      fprintf ( out, "\n" );
    fprintf ( out, "%2d, ", m->modPatternList[i] );
  }
  fprintf ( out, "\n" );
}

void doAllTheStuffForThePatternList ( struct modHead *modHead_ptr, struct modGeneral *modGen )
{
  modGen->modNbrPatternStored = getHighestPattern (modHead_ptr->modPatternList);
  modGen->modPatOuttaList = getPatOuttaList (modHead_ptr);
  doStufAboutUnusedPatterns ( modHead_ptr->modPatternList, modGen );
}

void doStufAboutUnusedPatterns ( char *t, struct modGeneral *m )
{
  char t2[128];
  unsigned char i;

  BZERO ( t2, 128 );
  m->modUnusedPatNbr = 0;

  for ( i=0x00; i<128; i+=0x01 )
    t2[(int)t[i]] = 0x01;
  for ( i=0x00; i<m->modNbrPatternStored ; i+=0x01 )
    if ( t2[i] == 0x00 )
      m->modUnusedPatList[m->modUnusedPatNbr++] = i;
}

signed long getPatOuttaList ( struct modHead *m )
{
  long i;
  for ( i=127; i>= 0 ; i-- )
    if ( m->modPatternList[i] != 0x00 )
      return ( i - m->modPatternListSize + 1);
  return 0;
}

long getHighestPattern ( char * p )
{
  long i,max=0l;
  for ( i=0; i<128; i++ )
    max = (p[i] > max) ? p[i] : max;
  return max+1;
}

void fillSmpDesc ( struct sampleDescription smpDesc_ptr[31], struct modGeneral *modGen, unsigned char *DataFile )
{
  long i;
  modGen->modWholeSampleSize = 0l;
  for ( i=0; i<((modGen->modHeadSize - 150)/30) ;i++ )
  {
    BZERO (smpDesc_ptr[i].smpName,23);
    strncpy (smpDesc_ptr[i].smpName, &DataFile[i*30+20], 22 );
    smpDesc_ptr[i].smpSize = (DataFile[i*30+42]*256 + DataFile[i*30+43])*2;
    smpDesc_ptr[i].smpFine = DataFile[i*30+44] > 0x08 ? DataFile[i*30+44]-16 : DataFile[i*30+44];
    smpDesc_ptr[i].smpVol = DataFile[i*30+45];
    smpDesc_ptr[i].smpLoopStart = (DataFile[i*30+46]*256 + DataFile[i*30+47])*2;
    smpDesc_ptr[i].smpLoopSize = (DataFile[i*30+48]*256 + DataFile[i*30+49])*2;

    modGen->modWholeSampleSize += smpDesc_ptr[i].smpSize;
  }
}

void fillModHead ( struct modHead *modHead_ptr, struct modGeneral *modGen, unsigned char *DataFile )
{
  /* XM first */
  /*  if ( (DataFile[37] == 0x1a) && (DataFile[0] == 'E') )
  {
    strncpy (modHead_ptr->modTitle, &DataFile[17], 20);
    modHead_ptr->modPatternListSize = &DataFile[64];
    modHead_ptr->modNTKByte = DataFile[66];*/ /* restart pos in XM */
  /*    memcpy (modHead_ptr->modPatternList, &DataFile[60], modHead_ptr->modHeadSize - 80 );
    return;
  }*/
  strncpy (modHead_ptr->modTitle, &DataFile[0], 20);
  modHead_ptr->modTitle[20] = 0x00;
  if (modGen->modHeadSize == 600)
    modGen->modPatListAddy = modGen->modHeadSize - 130;
  else
    modGen->modPatListAddy = modGen->modHeadSize - 134;

  modHead_ptr->modPatternListSize = DataFile[modGen->modPatListAddy];
  modHead_ptr->modNTKByte = DataFile[modGen->modPatListAddy+1];
  memcpy (modHead_ptr->modPatternList, &DataFile[modGen->modPatListAddy+2], 128 );
}

void getMusicType ( struct modGeneral *m ,unsigned char *DataFile )
{
  long nbrchannels;

  /* XM case first */
/*  if ( (DataFile[37] == 0x1a) && (DataFile[0] == 'E') )
  {
    bcopy ("Fastracker v2 (xm)\0",m->modType, 19 );
    m->modNbrChannels = DataFile[68];
    m->modHeadSize = (DataFile[63]*256*256*256)+(DataFile[62]*256*256)+(DataFile[61]*256)+DataFile[60]+60;
    return;
  }
*/
  m->modHeadSize = 1084;

  switch (DataFile[1080])
  {
    case 'M': /* M*K. */
    case 'F': /* FLT* */
      bcopy ("Pro/Noise/Star-Tracker\0", m->modType, 23 );
      m->modPatDefaultSiz = 1024;
      break;
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      nbrchannels = strtol ( &DataFile[1080], NULL, 10);
      sprintf ( m->modType, "Fastracker v1/v2 (%c%c%c%c)",DataFile[1080],DataFile[1081],DataFile[1082],DataFile[1083] );
/*       bcopy ("Fastracker v1/v2 ", m->modType, 23 ); */
      m->modPatDefaultSiz = nbrchannels*256;
      break;
    default:  /* stk */
      bcopy ("Soundtracker (or not :)\0", m->modType, 24 );
      m->modPatDefaultSiz = 1024;
      m->modHeadSize = 600;
      break;
   }
}

long returnFileSize ( char *in )
{
  long i;
  struct stat *Stat;
  Stat = (struct stat *) malloc ( sizeof (struct stat));
  stat ( in, Stat );
  i = (long)Stat->st_size;
  free ( Stat );
  return i;
}

/* 
 * read data from FILE "in" for "size" bytes.
 * File Pointer is after the read data
*/
unsigned char * readFile ( FILE *in, long size )
{
  unsigned char *DataFile;
  DataFile = (unsigned char *) malloc ( size );
  fseek ( in, 0, 0 );
  fread ( DataFile, size, 1, in );
  return DataFile;
}

void synopsis ( char *av )
{
  printf ( "%s %s\n"
	   "%s <Mod file>\n"
	   "where <Mod file> is either a Pro/Fast/Noise/SoundTracker file\n"
	   , VERSION, OS, av );
}
