#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>

#define BZERO(a,b)     memset(a,0,b)
#define VERSION        "ModInfo v2.32"

#ifdef AMIGA
#define FOPEN_IN_ARG   "r"
#define FOPEN_OUT_ARG  "w+"
#define OS             "(Amiga)"
#else /* not AMIGA */
#define FOPEN_IN_ARG   "r+b"
#define FOPEN_OUT_ARG  "w+b"
#ifdef LINUX
#define OS             "(Linux)"
#endif /* end ifdef LINUX */
#ifdef FREEBSD
#define OS             "(FreeBSD)"
#endif /* end ifdef FREEBSD */
#ifdef WIN32
#define OS             "(Win32)"
#endif /* end ifdef WIN32 */
#endif /* end ifdef AMIGA */

struct patStats
{
  long fx[32];
  long note[38];
  long smp[31];
};

struct modHead
{
  char modTitle[21];          /**/
  char modPatternListSize;    /* size of the pattern list - number of patterns to play */
  char modNTKByte;            /* "Noisetracker Byte" */
  char modPatternList[128];   /**/
};

struct instDescription
{
  char instName[23];
  int  nbrSample;
  struct sampleDescription *sampleDescPtr;
};

struct sampleDescription
{
  char smpName[23];
  int smpSize;
  int smpVol;
  signed int smpFine;
  int smpLoopStart;
  int smpLoopSize;
};

struct modGeneral
{
  long modSizeFile;           /* input file size */
  long modSizeCalc;           /* calculated size */
  long modWholeSampleSize;    /* sum of all the sample sizes */
  long modHeadSize;           /* header size (title+smpdesc+patternlist) */
  long modPatListAddy;        /* stk or ptk */
  long modNbrPatternStored;   /* number of pattern stored in file */
  long modPatOuttaList;       /* nbr of pattern in the list, farther than the list size(!?) */
  long modUnusedPatNbr;       /* nbr of unused patterns */
  char modUnusedPatList[128]; /* list of the unused patterns */
  char modType[32];           /* Pro/Fast/Star/Whatever-tracker */
  int  modPatDefaultSiz;      /* default size of a pattern */
  int  modNbrChannels;        /* number of channels */
};

long            returnFileSize    ( char * );
unsigned char * readFile          ( FILE *, long );
void            getMusicType      ( struct modGeneral *, unsigned char * );
void            fillModHead       ( struct modHead *, struct modGeneral *, unsigned char * );
void            fillSmpDesc       ( struct sampleDescription *, struct modGeneral *, unsigned char * );
long            getHighestPattern ( char * );
signed long     getPatOuttaList   ( struct modHead * );
void            doStufAboutUnusedPatterns ( char *, struct modGeneral * );
void            doAllTheStuffForThePatternList ( struct modHead *, struct modGeneral * );
void            fprintfSpecialPatList ( struct modHead *, FILE * );
void            fillFXStuff       ( long, unsigned char, struct patStats * );
void            fprintfSpecialFX  ( struct patStats *, FILE * );
void            readPatternStuff  ( struct modGeneral *, struct patStats *, unsigned char *, long * );
void            fillNoteStuff     ( long, struct patStats *, long * );
void            fprintfSpecialNotes ( struct patStats *, FILE * );
void            synopsis         ( char * );
